import os

from django_tools_log_context.celery import CtxAwareMixin

from celery import Celery, Task

from django.conf import settings

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'infra.cauth.server.master.settings')


class CAuthCeleryTask(CtxAwareMixin, Task):
    serializer = 'json'


app = Celery('infra.cauth.server.master', task_cls=CAuthCeleryTask)

app.config_from_object('django.conf:settings')
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)
