#!/bin/bash

# включает матера репликации ldap

ldif_dst="/var/lib/yandex/cauth-slapdconf-manager/ldif"
tmp="/tmp"
op=$1

NC='\033[0m'
cyan='\033[0;36m'
red='\033[0;31m'
green='\033[0;32m'

help()
{
	echo -e "${cyan}usage: ldapmaster [on|status]${NC}"
}

if [ ${#op} -eq 0 ]
then
	help
	exit 0
fi

if [ $op == "on" ]
then
	if [ ! -d /var/lib/ldap/accesslog ]
	then
		mkdir -p /var/lib/ldap/accesslog
	    chown -R openldap:openldap /var/lib/ldap
	fi

	echo "Modifying slapd.d configuration database..."
	ldapmodify -Q -Y EXTERNAL -H ldapi:/// -f $ldif_dst/module.ldif
	ldapadd -Y EXTERNAL -H ldapi:/// -f $ldif_dst/accesslogdbconfig.ldif
	ldapadd -Y EXTERNAL -H ldapi:/// -f $ldif_dst/syncprov_for_accesslogdb.ldif
	ldapadd -Y EXTERNAL -H ldapi:/// -f $ldif_dst/syncprov_for_maindb.ldif
	ldapadd -Y EXTERNAL -H ldapi:/// -f $ldif_dst/accesslog_definitions_for_maindb.ldif

	echo $(hostname -f)" now is ldap replication provider."
elif [ $op == "status" ]
then

	al_mod=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b cn=module{0},cn=config | grep "accesslog" | wc -l)
	if [ $al_mod -eq 1 ]
	then
		echo -e "${green}Accesslog module load: OK.${NC}"
	else
		echo -e "${red}Accesslog module load: Problem.${NC}"
	fi
	sp_mod=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b cn=module{0},cn=config | grep "syncprov" | wc -l)
	if [ $sp_mod -eq 1 ]
	then
		echo -e "${green}Syncprov module load: OK.${NC}"
	else
		echo -e "${green}Syncprov module load: Problem.${NC}"
	fi
	al_dbconf=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcDatabase={2}hdb,cn=config | egrep "olcDbDirectory:|olcSuffix:|entryCSN,objectClass,reqEnd,reqResult,reqStart|default eq" | wc -l)
	if [ $al_dbconf -eq 4 ]
	then
		echo -e "${green}Accesslog database config: OK.${NC}"
	else
		echo -e "${green}Accesslog database config: Problem.${NC}"
	fi
	spconf_aldb=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcOverlay={0}syncprov,olcDatabase={2}hdb,cn=config | egrep "olcOverlay:|olcSpNoPresent|olcSpReloadHint" | wc -l)
	if [ $spconf_aldb -eq 3 ]
	then
		echo -e "${green}Syncprov for accesslog db: OK.${NC}"
	else
		echo -e "${red}Syncprov for accesslog db: Problem.${NC}"
	fi
	spconf_main=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcOverlay={0}syncprov,olcDatabase={1}hdb,cn=config | egrep "olcOverlay:|olcSpNoPresent" | wc -l)
	if [ $spconf_main -eq 2 ]
    then
        echo -e "${green}Syncprov for main db: OK.${NC}"
    else
        echo -e "${red}Syncprov for main db: Problem.${NC}"
    fi
	aldef_formaindb=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcOverlay={1}accesslog,olcDatabase={1}hdb,cn=config | egrep "olcOverlay:|olcAccessLogDB:|olcAccessLogOps:|olcAccessLogPurge:|olcAccessLogSuccess:" | wc -l)
    if [ $aldef_formaindb -eq 5 ]
    then
        echo -e "${green}Accesslog definitions for main db: OK.${NC}"
    else
        echo -e "${red}Accesslog definitions for main db: Problem.${NC}"
    fi

else
	help
	exit 0
fi

exit 0
