$.fn.b_celery_log = function(options) {
    var $loader = $('<img class="e-loader">').attr('src', options.loader_url);
    var $content = this.find('.e-content');
    var $this = this;

    $content.append($loader);
    var current_offset = options.offset;

    function refresh() {
        $.ajax({
            url: options.url,
            dataType: 'json',
            data: {
                content_type: 'json',
                offset: current_offset
            },
            error: function() {
                setTimeout(refresh, 500);
            },
            success: function(data) {
                var do_scroll = $('body').height() - $(window).scrollTop() - $(window).height();

                $('<span>').text(data.content).insertBefore($loader);

                if (do_scroll < 50) {
                    $(window).scrollTop($('body').height());
                }

                if (data.finished) {
                    $this.find('.e-finish-time').text(data.finished);
                    $loader.remove();
                } else {
                    setTimeout(refresh, 500);
                    current_offset = data.size;
                }
            }
        });

    }

    setTimeout(refresh, 500);
};
