$(function(){
    $('.e-lock-trigger').qtip({
        style:{
            classes: 'qtip-bootstrap b-lock-popup',
            width: 500
        },
        position: {
            viewport: $(window),
            my: 'top center',
            at: 'bottom center'
        },
        show: {
            solo: true
        },
        hide: {
            fixed: true
        },
        content: {
            text: function(event, qtip) {
                var $container = $(qtip.target).closest('.e-task-lock');
                var template = _.template($('#lock-popup-template').text());

                var $el = $(template({
                    node: $container.data('lock-node'),
                    id: $container.data('lock-id'),
                    data: $container.find('.e-lock-data').text()
                }));

                $el.find('form').bind('submit', function(){
                    return confirm('Are you sure?');
                });

                return $el;
            }
        }
    });
});
