from django.conf.urls import url

from infra.cauth.server.master.dashboard.views import index, celery, imports


urlpatterns = [
    url(r'^$', index.index_view, name='dashboard-index'),
    url(r'^env/$', index.env_view, name='dashboard-env'),

    url(r'^celery/$', celery.index_view, name='dashboard-celery-index'),
    url(r'^celery/new/$', celery.task_view, name='dashboard-celery-new-task'),
    url(r'^celery/(?P<id>\d+)/$', celery.task_view, name='dashboard-celery-task'),
    url(r'^celery/(?P<id>\d+)/unlock/$', celery.unlock_view, name='dashboard-celery-unlock'),
    url(r'^celery/(?P<id>[0-9a-f-]{36})/$', celery.log_view, name='dashboard-celery-log'),

    url(r'^imports/$', imports.index_view, name='dashboard-imports-index'),
    url(r'^imports/download/$', imports.download_view, name='dashboard-imports-download'),
    url(r'^imports/delete/$', imports.delete_view, name='dashboard-imports-delete'),
    url(r'^imports/upload/$', imports.upload_view, name='dashboard-imports-upload'),
    url(r'^imports/run/$', imports.run_view, name='dashboard-imports-run'),
    url(r'^imports/unlock/$', imports.unlock_view, name='dashboard-imports-unlock'),
]
