import os

from .base import DashboardBaseView


class DashboardIndexView(DashboardBaseView):
    template_name = 'dashboard/base.html'
    content_type = 'html'

    NAV = 'home'

    def test_permissions(self, user_perms):
        return len(user_perms) > 0

    def get(self, request):
        return {}


class DashboardEnvView(DashboardBaseView):
    content_type = 'json'
    yalogin_required = False

    def test_permissions(self, user_perms):
        return True

    def get(self, request):
        return {
            'META': {k: v for k, v in list(request.META.items())
                     if isinstance(v, str)},
            'ENV': dict(os.environ),
        }


index_view = DashboardIndexView.as_view()
env_view = DashboardEnvView.as_view()
