import uuid

from django.db import models
from django.dispatch import receiver

from infra.cauth.server.master.files.models import S3File


@receiver(models.signals.post_delete, sender=S3File, dispatch_uid=str(uuid.uuid1()))
def remove_files_from_s3(sender, instance, using, **kwargs):
    instance.file.storage.delete(instance.file.name)
