from django.conf import settings

import boto3.session
from storages.backends.s3boto3 import S3Boto3Storage


class CAuthS3Boto3Storage(S3Boto3Storage):
    default_acl = 'public-read'

    @property
    def connection(self):
        connection = getattr(self._connections, 'connection', None)
        if connection is None:
            session = boto3.session.Session()

            cert_kwargs = {}
            if settings.AWS_S3_USE_INTERNAL_CERT:
                cert_kwargs = {'verify': settings.YANDEX_INTERNAL_CA_PATH}

            self._connections.connection = session.resource(
                's3',
                aws_access_key_id=settings.AWS_ACCESS_KEY_ID,
                aws_secret_access_key=settings.AWS_SECRET_ACCESS_KEY,
                use_ssl=True,
                endpoint_url=settings.AWS_S3_ENDPOINT_URL,
                config=self.config,
                **cert_kwargs
            )
        return self._connections.connection
