import logging

from django.db.models import Q
from django.utils import timezone

from infra.cauth.server.master.constants import FILE_TYPE
from infra.cauth.server.master.utils.tasks import task


log = logging.getLogger(__name__)


TTL_BY_FILE_TYPES = {
    FILE_TYPE.PUNCHER_CACHE: 1,  # days
    FILE_TYPE.IDM_CACHE: 2,
    FILE_TYPE.STAFF_HISTORY: 2,
    FILE_TYPE.SERVERS_HISTORY: 2,
}
PRESERVE_LAST_OBJECT_TYPES = [
    FILE_TYPE.PUNCHER_CACHE,
]


@task(dedicated_logger=False)
def cleanup_old_files():
    from infra.cauth.server.master.files.models import S3File

    now = timezone.now()

    q = Q()
    for file_type, days in TTL_BY_FILE_TYPES.items():
        old = now - timezone.timedelta(days)
        q |= Q(type=file_type, created_at__lt=old)

    exclude_q = Q()
    for file_type in PRESERVE_LAST_OBJECT_TYPES:
        last_pk = S3File.objects.get_last(file_type).pk
        exclude_q |= Q(pk=last_pk)

    log.info('Cleaning old S3File objects started.')
    count = S3File.objects.filter(q).exclude(exclude_q).delete()
    log.info('Cleaning old S3File objects finished. {} оbjects deleted.'.format(count))
