import logging
from optparse import make_option

from django.core.management.base import BaseCommand, CommandError

from infra.cauth.server.master.importers.registry import SuiteGroup


logger = logging.getLogger(__name__)


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('-f', '--filename', action='store'),
        make_option('--insane', action='store_true'),
    )

    args = 'group target'

    def handle(self, *args, **options):
        if len(args) != 2:
            raise CommandError("suite and target args are required")

        group, target = args
        try:
            suite_cls = SuiteGroup.registry[group].suites[target]
        except KeyError:
            raise CommandError("No suite for group %s for target %s",
                               group, target)

        filename = options['filename']
        if not filename:
            raise CommandError("filename is required")

        suite = suite_cls(insane_mode=options['insane'], logger=logger)

        if not suite.acquire_lock():
            logger.info("Already running: %s", suite.get_lock_name())
            return

        try:
            suite.run(in_filename=filename)
        finally:
            suite.release_lock()
