import logging
from optparse import make_option

from django.core.management.base import BaseCommand, CommandError

from infra.cauth.server.master.importers.fetch import fetch_group


logger = logging.getLogger(__name__)


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('-f', '--filename', action='store'),
    )

    args = 'group'

    def handle(self, *args, **options):
        if len(args) != 1:
            raise CommandError("group arg is required")

        group_name = args[0]

        fetch_group(group_name, filename=options.get('filename'), logger=logger)
