import contextlib

from django.core.management.base import BaseCommand

from infra.cauth.server.master.api.models import Server
from infra.cauth.server.master.importers.tasks import update_dns_statuses
from infra.cauth.server.common.alchemy import session_factory

ROW_IN_TRANSACTION = 500


def slice_indexes(count):
    full_session_count = count / ROW_IN_TRANSACTION
    mod = count % ROW_IN_TRANSACTION
    session_count = full_session_count + (1 if mod else 0)

    for session_number in range(session_count):
        start_index = session_number * ROW_IN_TRANSACTION
        if session_number != session_count - 1 or mod == 0:
            next_count = ROW_IN_TRANSACTION
        else:
            next_count = mod
        end_index = start_index + next_count

        yield start_index, end_index - 1


class Command(BaseCommand):
    args = ''
    help = 'Обновление / заполнение dns_status в таблице ServerFlags'

    def handle(self, *args, **kwargs):
        with contextlib.closing(session_factory()) as session:
            servers = session.query(Server) \
                .order_by(Server.id) \
                .all()

        servers_count = len(servers)
        for start_index, end_index in slice_indexes(servers_count):
            start_id = servers[start_index].id
            end_id = servers[end_index].id
            update_dns_statuses.delay(start_id, end_id)
