import os
import glob

from django.conf import settings
from django.utils.module_loading import import_string


class SuiteGroup(object):
    registry = {}

    def __init__(self, name, fetcher, validator, suites):
        self.name = name
        self.suites = suites

        if isinstance(fetcher, str):
            self.fetcher = import_string('infra.cauth.server.master.importers' + fetcher)
        else:
            self.fetcher = fetcher

        if isinstance(validator, str):
            self.validator = import_string('infra.cauth.server.master.importers' + validator)
        else:
            self.validator = validator

        for suite in list(suites.values()):
            suite.group = self

        self.registry[name] = self

    @property
    def last_data_filename(self):
        pattern = os.path.join(settings.IMPORTS_DIR,
                               '{}.*.json'.format(self.name))
        filenames = glob.glob(pattern)
        if not filenames:
            return None
        filenames.sort()
        return filenames[-1]

    @property
    def override_filename(self):
        if not settings.IMPORTS_OVERRIDE_DIR:
            return

        return os.path.join(settings.IMPORTS_OVERRIDE_DIR,
                            '.'.join((self.name, 'json')))
