import datetime
import json

from infra.cauth.server.common.alchemy import Session
from infra.cauth.server.common.models import Source

from infra.cauth.server.master.api.idm.update import IdmUpdateAggregator
from infra.cauth.server.master.importers.servers import to_database
from infra.cauth.server.master.importers.base import ImportSuite
from infra.cauth.server.master.importers.registry import SuiteGroup


class ServerDatabaseSuite(ImportSuite):
    TARGET = 'database'
    IMPORTER_CLASSES = (
        to_database.NewServerImporter,
        to_database.NewServerGroupImporter,
    )

    def post_run(self, instream):
        instream.seek(0)
        data = json.load(instream)

        timestamp = datetime.datetime.strptime(data['timestamp'], '%Y-%m-%dT%H:%M:%S.%f')

        for s in Source.query.filter(Source.name.in_(data['updated_sources'])):
            s.last_update = timestamp
            Session.add(s)

        Session.commit()

        IdmUpdateAggregator(self.run_id).finish_suite()

        super(ServerDatabaseSuite, self).post_run(instream)


SuiteGroup(
    name='servers',
    fetcher='.servers.aggregator.fetch_servers',
    validator='.servers.validators.ServersAndGroupsValidator',
    suites={
        'database': ServerDatabaseSuite,
    },
)
