from marshmallow import Schema, fields as f, validate as v


# структура файла servers.json
class ServersAndGroupsValidator(Schema):
    class Server(Schema):
        name = f.Str(required=True, validate=v.Length(max=128))  # полное имя хоста (fqdn)
        type = f.Str(required=True)  # тип сервера (обычный сервер, dev-сервер, etc.)
        responsibles = f.Dict(
            keys=f.Str(),
            values=f.List(f.Str()),
            required=True,
        )
        is_baremetal = f.Bool()

    class Group(Schema):
        class GroupContacts(Schema):
            request_email = f.Str(allow_none=True)  # email для запросов
            request_queue = f.Str(allow_none=True)  # очередь для запросов
            notify_email = f.Str(allow_none=True)  # очередь для уведомлений

        class GroupHost(Schema):
            hostname = f.Str(required=True, validate=v.Length(max=128))
            type = f.Str(required=True)
            is_baremetal = f.Bool()

        class GroupSettings(Schema):
            flow = f.Str(allow_none=True)  # имя FLOW_TYPE
            trusted_sources = f.List(f.Str())  # список имен источников

        class GroupKeysInfo(Schema):
            key_sources = f.List(f.Str(allow_none=True))  # список источников ключей
            secure_ca_list_url = f.Str(allow_none=True)
            insecure_ca_list_url = f.Str(allow_none=True)
            krl_url = f.Str(allow_none=True)
            sudo_ca_list_url = f.Str(allow_none=True)

        name = f.Str(required=True, validate=v.Length(max=128))  # имя группы с префиксом
        hosts = f.Nested('GroupHost', many=True)  # список пар fqdn - тип
        responsibles = f.List(f.Str())  # список логинов
        source = f.Str(required=True)  # source of group
        contacts = f.Nested(GroupContacts)
        settings = f.Nested(GroupSettings)
        keys_info = f.Nested(GroupKeysInfo)

    servers = f.Nested(Server, many=True, required=True)  # хосты
    groups = f.Nested(Group, many=True, required=True)  # группы хостов
    updated_sources = f.List(f.Str(), required=True)
    timestamp = f.Str(validate=v.Regexp(r'^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d+$'), required=True)
