from django.conf.urls import url

from infra.cauth.server.master.monitorings.views.imports import (
    SkippedInconsistenciesView,
    StaffImportView,
    ServersImportView,
)
from infra.cauth.server.master.monitorings.views.cache import PuncherCacheView, IdmCacheView
from infra.cauth.server.master.monitorings.views.ldap_wdog import LdapWdogView

urlpatterns = [
    url(r'^import-staff/$', StaffImportView.as_view(), name='import-staff'),
    url(r'^import-servers/$', ServersImportView.as_view(), name='import-servers'),
    url(r'^skipped-inconsistencies/$', SkippedInconsistenciesView.as_view(), name='skipped-inconsistencies'),

    url(r'^puncher-cache/$', PuncherCacheView.as_view(), name='puncher-cache'),
    url(r'^idm-cache/$', IdmCacheView.as_view(), name='idm-cache'),

    url(r'ldap-wdog/$', LdapWdogView.as_view(), name='ldap-wdog'),
]
