import time
import datetime

from infra.cauth.server.master.monitorings.views.base import BaseMonitoringView
from infra.cauth.server.master.constants import FILE_TYPE
from infra.cauth.server.master.files.models import S3File


class BaseCacheView(BaseMonitoringView):
    NORMAL_LAG = datetime.timedelta(hours=1)
    CACHE_FILE_TYPE = None

    def monitoring(self):
        last_file = S3File.objects.get_last(self.CACHE_FILE_TYPE)

        if not last_file:
            return '{0} does not exist'.format(self.CACHE_FILE_TYPE)

        timestamp = float(last_file.created_at.strftime('%s'))
        if time.time() - timestamp > self.NORMAL_LAG.total_seconds():
            file_date = datetime.datetime.fromtimestamp(timestamp)
            return 'Endpoint cache {} is old ({})'.format(self.CACHE_FILE_TYPE, file_date)


class PuncherCacheView(BaseCacheView):
    NORMAL_LAG = datetime.timedelta(hours=3)
    CACHE_FILE_TYPE = FILE_TYPE.PUNCHER_CACHE


class IdmCacheView(BaseCacheView):
    CACHE_FILE_TYPE = FILE_TYPE.IDM_CACHE
