import re
import time

import ldap
from django.conf import settings

from infra.cauth.server.master.monitorings.views.base import BaseMonitoringView


class LdapWdogView(BaseMonitoringView):
    wdog_cn_re = re.compile(r'^wdog_(\d+)$')
    TIME_SECONDS_THRESHOLD = 5 * 60

    def monitoring(self):
        connection = ldap.initialize('ldap://{}'.format(settings.LDAP_SERVER))
        result = connection.search_s(
            base='uid=cauth_watchdog,ou=people,dc=yandex,dc=net',
            scope=ldap.SCOPE_BASE,
        )

        if len(result) != 1:
            return 'Found invalid count of wdog users ({})'.format(len(result))

        _, entry = result[0]
        cns = entry.get('cn', [])
        if len(cns) != 1:
            return 'Found invalid count of CNs ({})'.format(len(cns))

        cn = cns[0].decode()
        match = self.wdog_cn_re.search(cn)
        if match is None:
            return 'Invalid wdog CN: ({})'.format(cn)

        ldap_time = int(match.group(1))
        now_time = int(time.time())
        time_diff = now_time - ldap_time
        if now_time - ldap_time > self.TIME_SECONDS_THRESHOLD:
            return 'last sync in {}. diff: {} seconds'.format(ldap_time, time_diff)
