import datetime

from infra.cauth.server.common.alchemy import Session

from infra.cauth.server.master.notify.models import NotifyEvent


def add_mail_queue_item(type, obj=None, who=None, what=None, requester=None,
                        description=None, role=None, recipient=None):

    if requester is None and obj:
        requester = obj.requester

    if who is None and obj:
        who = obj.src

    if what is None and obj:
        what = obj.dst

    Session.add(NotifyEvent(
        timestamp=datetime.datetime.now(),
        type=type,
        requester=requester,
        recipient=recipient,
        who=who,
        what=what,
        description=description or obj and obj.description,
        role=role,
    ))
    Session.commit()


def removed_from_group(login, group):
    return add_mail_queue_item(
        type='removed_from_group',
        who=login,
        what=group,
        requester='',
        description=' ',
    )
