from sqlalchemy import Column, Integer, String, Text, DateTime

from infra.cauth.server.common.models import BaseModel


class NotifyEvent(BaseModel):
    __tablename__ = 'notify_events'

    id = Column(Integer, primary_key=True)
    type = Column(String(30), nullable=False)
    timestamp = Column(DateTime, nullable=False)
    requester = Column(String(80), nullable=False)
    recipient = Column(String(80))
    who = Column(String(80), nullable=False)
    what = Column(String(80), nullable=False)
    role = Column(String(80))
    description = Column(Text)
