import logging

from django.utils.encoding import force_text

from infra.cauth.server.common.alchemy import Session

from infra.cauth.server.master.utils.tasks import task
from infra.cauth.server.master.notify.transports import DeliveryImpossibleError
from infra.cauth.server.master.notify.models import NotifyEvent
from infra.cauth.server.master.notify.notifications import event_notification

logger = logging.getLogger(__name__)


def get_notifications():
    notifications = {}
    for event in NotifyEvent.query.all():
        notification_class = event_notification[event.type]

        key = notification_class.get_key(event)
        if key not in list(notifications.keys()):
            notifications[key] = notification_class.create(key)

        notifications[key].update(event)

    return [notify for notify in list(notifications.values()) if notify.is_ready]


@task(dedicated_logger=False)
def send_notifications():
    for notification in get_notifications():
        try:
            notification.deliver()

            for event in notification.events:
                Session.delete(event)

            Session.commit()
        except DeliveryImpossibleError as error:
            text = force_text(error.response.content)
            logger.exception("Failed to deliver notification: %s", text)
        except Exception:
            logger.exception("Failed to deliver notification")
