from django.conf.urls import url, include

from infra.cauth.server.master.api.views.errors import internal_error
from infra.cauth.server.master.api.views.servers import AddServerView, RemoveServerView
from infra.cauth.server.master.api.views.misc import StatusView, PingView
from infra.cauth.server.master.api.views.client import ClientUpdateServerView
from infra.cauth.server.master.api.views.puncher import PuncherView

from infra.cauth.server.master.dashboard import urls as dashboard_urls
from infra.cauth.server.master.monitorings import urls as monitorings_urls

handler500 = internal_error

urlpatterns = [
    url(r'^idm/', include('django_idm_api.urls', 'client-api')),

    url(r'^add_server/?$', AddServerView.as_view()),
    url(r'^remove_server/?$', RemoveServerView.as_view()),

    url(r'^update_server/?$', ClientUpdateServerView.as_view()),

    url(r'^status/?$', StatusView.as_view()),
    url(r'^ping/?$', PingView.as_view()),

    url(r'^puncher/rules/?$', PuncherView.as_view()),

    url(r'^dashboard/', include(dashboard_urls)),

    url(r'^monitorings/', include(monitorings_urls)),
]
