import contextlib

from infra.cauth.server.common.alchemy import session_factory
from infra.cauth.server.master.api.models import ConfigValue


def get_config(id, default=None):
    with contextlib.closing(session_factory()) as session:
        cfg = session.query(ConfigValue).filter_by(id=id).first()

        if cfg:
            return cfg.value
        else:
            return default


def service_is_readonly():
    with contextlib.closing(session_factory()) as session:
        read_only, = session.execute('SHOW transaction_read_only')
    return read_only == 'on'


def get_class_path(obj):
    if isinstance(obj, type):
        cls = obj
    else:
        cls = type(obj)

    return '.'.join((
        cls.__module__,
        cls.__name__,
    ))
