from django.conf import settings


def should_be_added(fqdn):
    if not fqdn:
        return False
    if '.' not in fqdn:
        return False
    if fqdn.endswith(tuple(settings.CAUTH_ADD_FQDN_IGNORE_DOMAINS)):
        return False
    return True


def should_be_pushed(fqdn):
    should_be_ignored = fqdn.endswith(tuple(settings.CAUTH_IDM_PUSH_IGNORE_DOMAINS))
    return not should_be_ignored
