import urllib.request
import urllib.parse
import urllib.error

from django.conf import settings


ESCAPE_COUNTS = {
    '\\': 31,
    ':': 16,
    ';': 8,
    '#': 4,
    '=': 2,
    ',': 1,
}


def escape_field_value(value):
    newstring = []
    for char in value:
        if char in ESCAPE_COUNTS:
            newstring.append('\\' * ESCAPE_COUNTS[char] + char)
        else:
            newstring.append(char)

    return ''.join(newstring)


def build_idm_form_url(rules):
    """Это можно будет переделать на что-то более простое,
    когда фронтенд idm будет принимать json или querystring
    """

    parts = []
    rule_part_template = 'rf-role={rf}#cauth/{dst}/{type};{fields};;'
    for rf, rule in enumerate(rules):
        field = ''
        if rule.type == 'ssh' and rule.ssh_is_admin:
            field = 'root:true'
        elif rule.type == 'sudo' and rule.sudo_role.spec:
            value = escape_field_value(rule.sudo_role.spec)
            field = 'role:{}'.format(value)

        role_part = rule_part_template.format(
            rf=rf,
            dst=rule.dst,
            type=rule.type,
            fields=field,
        )

        parts.append(role_part)

    parts.extend(['rf-expanded=0', 'rf=1'])

    return settings.CAUTH_IDM_ROLEREQUEST_FORM_URL + urllib.parse.quote(','.join(parts))
