import datetime
import json
import bson


class CustomEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, datetime.datetime):
            return obj.isoformat(sep=' ')
        if isinstance(obj, bson.ObjectId):
            return str(obj)
        return super(CustomEncoder, self).default(obj)
