PY3_LIBRARY(cauth_master)

OWNER(g:cauth)

PEERDIR(
    contrib/python/attrs
    contrib/python/boto3
    contrib/python/celery
    contrib/python/decorator
    contrib/python/django-celery-beat
    contrib/python/django-constance
    contrib/python/django-picklefield
    contrib/python/django-storages
    contrib/python/django-waffle
    contrib/python/django-widget-tweaks
    contrib/python/dnspython
    contrib/python/lxml
    contrib/python/marshmallow
    contrib/python/marshmallow-oneofschema
    contrib/python/netaddr
    contrib/python/python-ldap
    contrib/python/requests
    contrib/python/setuptools

    library/python/datasources-config-wrapper
    library/python/django-idm-api
    library/python/django_tools_log_context
    library/python/granular_settings
    library/python/ids
    library/python/metrics_framework
    library/python/python-django-yauth
    library/python/yenv

    infra/cauth/server/common
    infra/cauth/server/master/api
    infra/cauth/server/master/cache
    infra/cauth/server/master/dashboard
    infra/cauth/server/master/files
    infra/cauth/server/master/importers
    infra/cauth/server/master/notify

    # development packages
    contrib/python/ipdb
    contrib/python/ipython
)

PY_SRCS(
    celery_app.py
    __init__.py
    manage.py
    metrics/__init__.py
    metrics/functions.py
    monitorings/views/__init__.py
    monitorings/views/base.py
    monitorings/views/cache.py
    monitorings/views/imports.py
    monitorings/views/ldap_wdog.py
    monitorings/__init__.py
    monitorings/urls.py
    settings.py
    utils/__init__.py
    utils/cache.py
    utils/http_client.py
    utils/json_encoder.py
    utils/mongo.py
    utils/validation.py
    utils/config.py
    utils/database.py
    utils/dns_status.py
    utils/fqdn.py
    utils/idm.py
    utils/iterable.py
    utils/log.py
    utils/nda.py
    utils/subtasks.py
    utils/tasks.py
    constants.py
    urls.py
)

RESOURCE_FILES(
    PREFIX master/

    settings/000-debug.conf
    settings/000-paths.conf
    settings/000-paths.conf.development.unittest
    settings/001-mkpaths.conf
    settings/005-static.conf
    settings/010-apps.conf
    settings/015-datasources.conf.development
    settings/015-datasources.conf.production
    settings/015-datasources.conf.qa
    settings/015-datasources.conf.testing
    settings/020-database.conf
    settings/020-database.conf.development.migration
    settings/020-database.conf.development.unittest
    settings/030-security.conf
    settings/030-security.conf.development.unittest
    settings/030-security.conf.production
    settings/030-security.conf.testing
    settings/040-middleware.conf
    settings/045-yauth.conf
    settings/045-yauth.conf.development.unittest
    settings/050-templates.conf
    settings/060-notifications.conf
    settings/060-notifications.conf.development.unittest
    settings/060-notifications.conf.testing
    settings/062-mongodb.conf
    settings/065-celery.conf
    settings/065-celery.conf.development.unittest
    settings/067-ylock.conf
    settings/068-idm.conf
    settings/068-idm.conf.production
    settings/068-idm.conf.testing
    settings/070-logging.conf
    settings/080-cache.conf
    settings/099-misc.conf
    settings/099-misc.conf.development.unittest
    settings/110-imports.conf
    settings/110-imports.conf.development
    settings/110-imports.conf.production
    settings/110-imports.conf.testing
    settings/130-constance.conf
    settings/140-metrics.conf
    settings/150-puncher.conf
    settings/160-storage.conf
    settings/160-storage.conf.development.unittest
    settings/160-storage.conf.production
    settings/170-idm-api.conf
    settings/180-cauth.conf
)

END()

RECURSE(
    wsgi
)

RECURSE_FOR_TESTS(
    tests
)
