import datetime

from django.core.management.base import BaseCommand
from django.core.cache import cache
from django.template.loader import get_template

from infra.cauth.server.common.models import ImportStatus
from infra.cauth.server.public.api.helpers import get_posix_passwd_new, get_posix_groups_new
from infra.cauth.server.public.api.views.posix import AllGroupsView, AllPasswdView


class Command(BaseCommand):
    def update_groups(self, view_cls, data_func, ref_time):
        entry = cache.get(view_cls.cache_key)
        if entry:
            timestamp, body = entry

            if timestamp >= ref_time:
                return

        template = get_template(view_cls.template_name).template
        entry = (
            datetime.datetime.now(),
            template.render({
                'items': list(map(view_cls.item_from_tuple, data_func())),
            }).strip(),
        )
        cache.set(view_cls.cache_key, entry)

    def handle(self, **options):
        query = ImportStatus.query.filter_by(suite='staff', target='database')
        status = query.first()
        if not status:
            return

        ref_time = status.last_import
        self.update_groups(AllGroupsView, get_posix_groups_new, ref_time)
        self.update_groups(AllPasswdView, get_posix_passwd_new, ref_time)
