from django.http import HttpResponse
from django.template.loader import get_template

from infra.cauth.server.public.api.views.base import BaseView


def index_view(request):
    template = get_template('api/index.html').template

    return HttpResponse(template.render(), content_type='text/html')


class CheckFqdnView(BaseView):
    template_name = 'api/check_fqdn.txt'

    def get_context_data(self):
        return {
            'ip': self.effective_remote_addr,
            'fqdn': self.effective_remote_fqdn,
        }
