from infra.cauth.server.common.alchemy import Session
from infra.cauth.server.common.models import Access
from infra.cauth.server.public.api.helpers import get_access_dst_filters
from infra.cauth.server.public.api.views.base import BaseSourceView


class AccessView(BaseSourceView):
    template_name = 'api/access.txt'

    default_context = {
        'entries': [],
    }

    @property
    def can_make_context(self):
        return self.can_use_access

    def make_context(self):
        access_query = (
            Session.query(Access.src)
            .filter(*get_access_dst_filters(self.remote_server, 'ssh', self.sources))
        )

        return {
            'entries': sorted({src for src, in access_query}),
        }


class SudoersView(BaseSourceView):
    template_name = 'api/sudoers.txt'

    default_context = {
        'entries': [],
    }

    @property
    def can_make_context(self):
        return self.can_use_access

    def make_context(self):
        return {
            'entries': self.get_sudoers(),
        }
