#!/bin/bash

ldif_dst="/var/lib/yandex/cauth-slapdconf-manager/ldif"
op=$1
newmasrter=$2
tmp="/tmp"

NC='\033[0m'
cyan='\033[0;36m'
red='\033[0;31m'
green='\033[0;32m'

help()
{
	echo -e "${cyan}usage: slave.sh [off|on|status] [new_master_fqdn]${NC}"
	echo -e "${cyan}new_master_fqdn must be specified when executing with \"on\"${NC}"
	echo -e "${cyan}new_master_fqdn must be real hostname and should be resolved.${NC}"
}

if [ "$op" == "off" ]
then
	ldapmodify -Q -Y EXTERNAL -H ldapi:/// -f $ldif_dst/disable_replication_slave.ldif
elif [ "$op" == "on" ]
then
	if [ ! ${#newmasrter} -gt 0 ]
	then
		help
		exit 0
	fi

	checkfqdn=$(host $newmasrter | grep "not found" | wc -l)
	if [ $checkfqdn -gt 0 ]
	then
		help
		exit 0
	fi

	# подставляем указанный параметром fqdn для нового мастера
	sed -r s/[a-z]{2}-cauth[0-9]{2}[a-z]{2}.yandex.ru/$newmasrter/ $ldif_dst/enable_replication_slave.ldif > $tmp/enable_replication_slave.ldif
	ldapmodify -Q -Y EXTERNAL -H ldapi:/// -f $tmp/enable_replication_slave.ldif
elif [ "$op" == "status" ]
then
	syncreplconf=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcDatabase={1}hdb,cn=config | egrep -i "olcSyncRepl:|olcUpdateRef" | wc -l)
	if [ $syncreplconf -eq 2 ]
	then
		master=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcDatabase={1}hdb,cn=config | egrep -i olcUpdateRef | awk -F "\/\/" '{print $2}')
		# проверяем что оба параметра настроены на один и тот же hostname
		iscorrect=$(ldapsearch -Q -LLL -Y EXTERNAL -H ldapi:///  -b olcDatabase={1}hdb,cn=config | egrep -i "$master" | wc -l)
		if [ $iscorrect -eq 2 ]
		then
			echo -e "${green}Slave configuration: OK.${NC}"
			echo -e "${green}Master server: $master${NC}"
		else
			echo -e "${red}Slave configuration: Problem: Different hosts in olcUpdateRef and olcSyncrepl${NC}"
		fi
	else
		echo -e "${red}Slave configuration: Problem: Check variables olcUpdateRef and olcSyncrepl.${NC}"
	fi
else
	help
	exit 0
fi
