#!/bin/bash

code="0"
msg="Ok"

warn="28"
crit="15"

statfile="/tmp/yandex-tools-cert-check.stat"
conffile="/etc/yandex/yandex-tools-cert-check/yandex-tools-cert-check.conf"

if [[ -s $conffile ]]; then
    certdir=$(cat $conffile | egrep -v '^#|^$' | tr '\n;,' '   ')
else
    certdir="/etc/yandex"
fi

now=$(date +%s)

if [[ -f $statfile ]]; then
    statmtime=$(stat --printf=%Y $statfile)
    # Проверяем не чаще раза в сутки
    if [[ $(($now - $statmtime)) -lt 86400 ]]; then
        cat $statfile
        exit 0
    fi
fi

echo "1;Check running" > $statfile

function setcode {
    if [[ $1 -gt $code ]]; then
        code="$1"
    fi
}

function addreason {
    if [[ $msg == "Ok" ]]; then
        msg="$1"
    else
        msg="$msg, $1"
    fi
}

certs=$(find $certdir -regextype egrep -regex ".*(crt|cer|pem)" -printf "%p ")
certs=$(find $certdir -regextype egrep \( -regex ".*(crt|cer|pem)" ! -iname 'cafile.pem' \) -printf "%p ")

for cert in $certs; do

# Похоже на сертификат
grep -q 'CERTIFICATE' $cert || continue

sslinfo=$(openssl x509 -in $cert -noout -enddate -subject)

subj=$(echo "$sslinfo" | egrep '^subject=' | egrep -o 'CN=[^/]*' | sed 's/^CN=//')
endstr=$(echo "$sslinfo" | egrep '^notAfter=' | sed 's/^notAfter=//')
enddate=$(date +%s -d "$endstr")

# Похоже на дату
if [[ $enddate =~ [0-9]{10} ]]; then
    setcode 0
else
    setcode 1
    addreason "$subj get unix date failed"
    continue
fi

diff=$(( ($enddate - $now)/86400 ))

if [[ $diff -gt $warn ]]; then
    setcode 0
    addreason "$subj ok"
elif [[ $diff -gt $crit ]]; then
    setcode 1
    addreason "$subj expires in $diff days"
else
    setcode 2
    addreason "$subj expires in $diff days"
fi

done

echo "$code;$msg"
echo "$code;$msg" > $statfile
