class SOURCE_NAME:
    DEFAULT = 'default'
    WALLE = 'walle'
    IDM = 'idm'
    IDM_CMS = 'idm-cms'
    IDM_CONDUCTOR = 'idm-conductor'
    CONDUCTOR = 'conductor'
    CMS = 'cms'
    GOLEM = 'golem'

    IDM_SOURCES = {IDM, IDM_CMS, IDM_CONDUCTOR}

    SOURCES_MAP = {
        IDM_CMS: CMS,
        IDM_CONDUCTOR: CONDUCTOR,
    }

    @classmethod
    def choices(cls):
        return [
            cls.WALLE,
            cls.IDM,
            cls.IDM_CMS,
            cls.IDM_CONDUCTOR,
            cls.CONDUCTOR,
            cls.CMS,
            cls.GOLEM,
        ]

    @classmethod
    def get_addition_sources(cls, sources_names):
        addition_sources = set()
        for source_name in cls.SOURCES_MAP:
            if source_name in sources_names:
                addition_sources.add(cls.SOURCES_MAP[source_name])

        return addition_sources
