import urllib.parse
import logging

import requests

from django.conf import settings

log = logging.getLogger(__name__)


class MasterApiClient:
    @classmethod
    def update_server(cls, server, sources, client_version):
        content = {
            'fqdn': server.fqdn,
        }

        if sources is not None:
            content['sources'] = [source.name for source in sources]

        if client_version is not None:
            content['client_version'] = client_version

        api_url = urllib.parse.urljoin(settings.CAUTH_MASTER_API_URL, settings.CAUTH_UPDATE_SERVER_URL)

        try:
            requests.post(
                api_url,
                json=content,
                timeout=settings.CAUTH_MASTER_API_TIMEOUT,
                verify=settings.ROOT_CA_BUNDLE,
                cert=(settings.CAUTH_CLIENT_CERT_PEM_PATH, settings.CAUTH_CLIENT_CERT_KEY_PATH),
            )
        except requests.RequestException:
            log.exception('Error in master api push')
