from django.conf.urls import url

from infra.cauth.server.public.api.views.errors import internal_error
from infra.cauth.server.public.api.views.info import SourcesInfoView
from infra.cauth.server.public.api.views.misc import index_view, CheckFqdnView
from infra.cauth.server.public.api.views.rules import AccessView, SudoersView
from infra.cauth.server.public.api.views.keys import UserkeysView, AdminkeysView, UnitkeysView, KeysInfoView
from infra.cauth.server.public.api.views.posix import (
    AllGroupsView,
    AllPasswdView,
    AdminsGroupView,
    UsersGroupView,
    AdminsPasswdView,
    UsersPasswdView,
)

handler500 = internal_error

urlpatterns = [
    url(r'^$', index_view),
    url(r'^check_fqdn/?$', CheckFqdnView.as_view()),

    url(r'^access/?$', AccessView.as_view()),
    url(r'^sudoers/?$', SudoersView.as_view()),

    url(r'^userkeys/?$', UserkeysView.as_view()),
    url(r'^adminkeys/?$', AdminkeysView.as_view()),
    url(r'^userkeys/(?P<name>[\w\.-]+)/?$', UnitkeysView.as_view()),
    url(r'^keysinfo/?$', KeysInfoView.as_view()),

    url(r'^group/?$', AllGroupsView.as_view()),
    url(r'^passwd/?$', AllPasswdView.as_view()),
    url(r'^group/serveradmins/?$', AdminsGroupView.as_view()),
    url(r'^group/serverusers/?$', UsersGroupView.as_view(), name='group-serverusers'),
    url(r'^passwd/serveradmins/?$', AdminsPasswdView.as_view()),
    url(r'^passwd/serverusers/?$', UsersPasswdView.as_view()),

    url(r'^info/?$', SourcesInfoView.as_view()),
]
