import tempfile
import subprocess

from django.utils.encoding import force_text


def is_correct_sudoers(sudoers_text):
    if type(sudoers_text) == bytes:
        sudoers_text = force_text(sudoers_text)
    with tempfile.NamedTemporaryFile() as f:
        f.write(sudoers_text.encode('utf-8'))
        f.flush()

        try:
            subprocess.check_call(('/usr/sbin/visudo', '-cf', f.name))
        except subprocess.CalledProcessError:
            return False

    return True


def is_correct_sudo_rule(sudo_rule):
    sudoers_text = 'login {}\n'.format(sudo_rule)
    return is_correct_sudoers(sudoers_text)
