"""
WSGI config for cauth.public project.

It exposes the WSGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/1.7/howto/deployment/wsgi/
"""

import os

from django.core.wsgi import get_wsgi_application


os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'infra.cauth.server.public.settings')
application = get_wsgi_application()


try:  # eager application loading
    from uwsgidecorators import postfork

    @postfork
    def init():
        from django.test.client import Client
        Client().get('/')
except ImportError:
    pass  # not started from uwsgi
