PY3_LIBRARY(cauth_public)

OWNER(g:cauth)

PEERDIR(
    contrib/python/attrs
    contrib/python/setuptools
    contrib/python/MarkupSafe
    contrib/python/django-appconf
    contrib/python/netaddr
    contrib/python/psycopg2
    contrib/python/python-memcached
    contrib/python/requests

    library/python/datasources-config-wrapper
    library/python/django_tools_log_context
    library/python/granular_settings
    library/python/yenv

    infra/cauth/server/common
    infra/cauth/server/public/api

    # development packages
    contrib/python/ipdb
    contrib/python/ipython
)

PY_SRCS(
    utils/__init__.py
    utils/cache.py
    utils/db.py
    utils/sudo.py
    __init__.py
    constants.py
    manage.py
    master_api.py
    settings.py
    urls.py
)

RESOURCE_FILES(
    PREFIX public/

    settings/000-debug.conf
    settings/000-paths.conf
    settings/010-apps.conf
    settings/015-datasources.conf.development.unittest
    settings/015-datasources.conf.production
    settings/015-datasources.conf.testing
    settings/020-database.conf
    settings/020-database.conf.development.unittest
    settings/030-security.conf
    settings/040-middleware.conf
    settings/050-templates.conf
    settings/060-cache.conf
    settings/060-cache.conf.development.unittest
    settings/070-logging.conf
    settings/080-smoke.conf
    settings/099-misc.conf
    settings/100-cauth.conf
)

END()

RECURSE(
    wsgi
)

RECURSE_FOR_TESTS(
    tests
)
