import re
import itertools


def braceExpansion(argv, asString=False):
    """
    This is a simple bash brace expansion function. It does not supports nested braces but is pretty
    useful for expand hosts list packed by previously executed command.
    :param argv:        A list of expression to be processed.
    :param asString:    Perform result concatenation into a single string joined with space symbol.
    :return:            Expanded list or string depending on `asString` argument.
    """
    r = re.compile(r'''
        ([^{]*)
        {
            (?:(?:((?:0*)(\d+))\.\.((?:0*)(\d+)))
            |
            ([^{}\s]+))
        }
        ([^{}]*)
    ''', re.VERBOSE)
    hosts = []
    for arg in itertools.chain(*(s.split() for s in argv)):
        pos = 0
        addon = []
        while pos < len(arg):
            m = r.match(arg, pos)
            if not m:
                break
            prev = pos
            pos = m.end()
            if m.group(3) and m.group(5):  # Range
                mlen = max(len(m.group(i)) for i in [2, 4])
                chunk = map(
                    lambda x: '{0}{1:0{len}d}{2}'.format(m.group(1), x, m.group(7), len=mlen),
                    range(int(m.group(3)), int(m.group(5)) + 1)
                )
            elif m.group(6):
                chunk = map(
                    lambda x: ''.join([m.group(1), x, m.group(7)]),
                    m.group(6).split(',')
                )
            else:
                chunk = [arg[prev:pos]]
            addon = \
                chunk \
                if not addon else \
                list(itertools.chain.from_iterable(map(lambda x: x + s, addon) for s in chunk))
        hosts += addon if addon else [arg]

    return hosts if not asString else ' '.join(hosts)
