import datetime

from libraries.topology import get_group_by_version


def intersect_groups(actual, future):
    groups = {}
    for g in actual + future:
        name, version = g
        if name not in groups:
            groups[name] = set()
        groups[name].add(version)
    return groups


class Limits(object):
    def __init__(self):
        self.cpu = 0
        self.mem = 0

    def max(self, other):
        if other.cpu > self.cpu:
            self.cpu = other.cpu
        if other.mem > self.mem:
            self.mem = other.mem

    def __add__(self, other):
        new = Limits()
        new.add(other)
        return new

    def add(self, other):
        self.cpu += other.cpu
        self.mem += other.mem

    def drop(self):
        self.cpu, self.mem = 0, 0

    def json(self, human=False):
        if human:
            return {'mem': {'guarantee': '{0:.2}G'.format(float(self.mem) / 1024 ** 3)},
                    'cpu': {'guarantee': self.cpu}}
        return {'mem': {'guarantee': self.mem}, 'cpu': {'guarantee': self.cpu}}


def _get_mem(mem_guarantee, mem_limit):
    if mem_guarantee * 1.05 < mem_limit:
        return mem_guarantee
    if mem_guarantee + 1024**3 < mem_limit:
        return mem_guarantee
    return mem_limit


def is_satisfy(host, since, duration):
    # HACK: useful to smoothly change something in clusters mem/cpu requirements
    # or config format and so on.
    try:
        number = int(host.split('-')[1].split('.')[0])
    except (TypeError, IndexError, ValueError):
        return False
    prob = ((datetime.datetime.now() - since).total_seconds() / duration)
    if prob * 10000 > number:
        return True
    return False


def limits(host, groups, fresh_topology=None, calc_info=True, ignore_group=None):
    fresh_topology = fresh_topology or {}
    res = Limits()
    info = {}
    tmp, max_ = Limits(), Limits()
    for g, versions in groups.iteritems():
        if g == ignore_group:
            continue
        max_.drop()
        for ver in versions:
            gr_ve = fresh_topology.get((g, ver)) or get_group_by_version(g, ver)
            gr_ve = gr_ve['hosts']
            tmp.drop()
            for instance in gr_ve[host].itervalues():
                tmp.mem += instance['mem_guarantee']
                tmp.cpu += instance['cpu_guarantee']
            max_.max(tmp)
        res.add(max_)
        if calc_info:
            info[g] = max_.json(human=True)
            info[g].update(versions=list(versions))
    return res.json(), info
