from libraries.utils import memoize
import pymongo

from ..mongo_params import ALL_HEARTBEAT_C_MONGODB


@memoize
def containers():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['psi']['containers']


@memoize
def clusters():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['psi']['clusters']


@memoize
def allocations():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['psi']['allocations']


@memoize
def smooth():
    return pymongo.MongoReplicaSetClient(
        ALL_HEARTBEAT_C_MONGODB.uri,
        replicaset=ALL_HEARTBEAT_C_MONGODB.replicaset,
        localThresholdMS=30000,
        connectTimeoutMS=5000,
        read_preference=ALL_HEARTBEAT_C_MONGODB.read_preference
    )['psi']['smooth']
