import functools
import logging
import pymongo
import time


def auto_reconnect(fn, max_attempts=5):
    @functools.wraps(fn)
    def wrapper(*args, **kwargs):
        e = None

        for attempt in xrange(max_attempts):
            try:
                return fn(*args, **kwargs)
            except pymongo.errors.AutoReconnect as e:
                wait_time = pow(2, attempt)
                logging.warning(
                    'PyMongo failed with auto reconnect: [%s]. Attempt %s. Sleep %s seconds',
                    str(e),
                    attempt,
                    wait_time
                )
                time.sleep(wait_time)
        raise e

    return wrapper
