""" Copypasted from instanceusage.py """


class UnpackBuffer(object):
    def __init__(self, serialized_data):
        self.v = 0
        for i in range(len(serialized_data)):
            self.v += ord(serialized_data[i]) << (i * 8)
        self.offset = 0

    def _unpack_bits(self, sz):
        result = (self.v >> (self.offset)) % (1 << sz)
        self.offset += sz
        return result

    def unpack_int(self, sz):
        return self._unpack_bits(sz)

    def unpack_percents(self, sz):
        return float(self._unpack_bits(sz)) / (1 << sz)

    def unpack_float(self, maxv, mantissa, exponenta):
        mant = self._unpack_bits(mantissa)
        exp = self._unpack_bits(exponenta)
        return mant / float(1 << mantissa) / (1 << exp) * maxv

    def finish(self):
        pass


class Serializer(object):
    VERSION = 1

    def __init__(self, buf):
        self.buf = buf
        self.offset = 0

    @staticmethod
    def deserialize(serialized_data):
        buf = UnpackBuffer(serialized_data)
        instances_data = []

        version = buf.unpack_int(5)
        if version == 1:
            n = buf.unpack_int(8)
            for i in range(n):
                instance_data = {}
                instance_data['port'] = buf.unpack_int(16)
                instance_data['major_tag'] = buf.unpack_int(8)
                instance_data['minor_tag'] = buf.unpack_int(8)
                instance_data['instance_cpu_usage'] = buf.unpack_percents(10)
                instance_data['instance_mem_usage'] = buf.unpack_float(1024., 6, 4)
                instances_data.append(instance_data)

            buf.finish()

            return instances_data
        else:
            raise Exception, "Unsupported version %s for deserialization"
