import datetime

from . import mongo


def aggregate_series(sources, counter, start, finish):
    aggr = []
    for source in sources:
        for val in iter_series(source, counter, start, finish):
            aggr.append(val)
    return aggr


def iter_series(source, counter, start, finish):
    for time, value in iter_whole_days(source, counter, start, finish):
        if start < time < finish:
            yield time, (value['c'] / value['n'] if value['n'] else None)


def iter_whole_days(source, counter, start, finish):
    start = day(start)
    finish = day(finish)
    coll = mongo.coll

    for daily_data in coll.find({
        'source': source,
        'counter': counter,
        '$and': [
            {'day': {'$gte': day(start)}},
            {'day': {'$lte': day(finish)}}
        ],
    }).sort('day', 1):
        date = daily_data['day']
        for hour in xrange(24):
            for point in points():
                time = datetime.datetime.combine(date, datetime.time(hour, point * point_length))
                value = daily_data['hours'][str(hour)][str(point)]
                yield time, value


point_length = 10  # minutes


def get_point(time):
    return time.minute / point_length


def points():
    return xrange(60 / point_length)


def day(date):
    return datetime.datetime.combine(date.date(), datetime.time.min)
