import pymongo
import libraries.utils as utils
import libraries.mongo_params as mongo_params


def _coll():
    return pymongo.MongoReplicaSetClient(
        mongo_params.ALL_HEARTBEAT_C_MONGODB.uri,
        connectTimeoutMS=500,
        replicaset=mongo_params.ALL_HEARTBEAT_C_MONGODB.replicaset,
        read_preference=mongo_params.ALL_HEARTBEAT_C_MONGODB.read_preference
    )['topology']['hosts']


@utils.memoize
def load():
    return list(_load(search=True, yt=True))


@utils.memoize
def load_all(market=False):
    return list(_load(search=True, yt=True, market=market))


@utils.memoize
def load_really_everything():
    return list(_load(with_filter=False))


def _load(with_filter=True, search=False, market=False, yt=False):
    if with_filter:
        allowed_domains = set()
        if search:
            allowed_domains |= {'.search.yandex.net', '.vm.search.yandex.net'}
        if market:
            allowed_domains |= {'.market.yandex.net'}
        if yt:
            for domain in _coll().distinct('domain'):
                if domain.endswith('.yt.yandex.net'):
                    allowed_domains.add(domain)

    for host in _load_coll():
        if not with_filter or host['domain'] in allowed_domains:
            yield host


@utils.memoize
def _load_coll():
    return list(_coll().find({}, {'_id': False}))
