import collections
import yaml

import library.python.resource as resource


ProcessorModel = collections.namedtuple('ProcessorModel', ['power', 'ncpu'])


def load():
    models = {}
    for model in yaml.load(resource.find('/hwmodels')):
        models[model['model']] = ProcessorModel(power=model['power'], ncpu=model['ncpu'])

    return models
