import datetime

from libraries.online_state import online_state
from libraries.online_state.online_state import GroupState, OnlineState


def test_groupstate():
    now = datetime.datetime.now()
    g = GroupState(load_group('group3', 'rev1'))

    assert set(g.iter_hosts()) == {'h1', 'h2', 'h3'}
    assert set(g.iter_alive_instances()) == set()
    assert set(g.iter_all_instances()) == load_group('group3', 'rev1')

    g.set_alive('h1', ('h1', 'p1'), now)
    assert set(g.iter_alive_instances()) == {('h1', 'p1')}

    g.set_alive('h1', ('h1', 'p3'), now)
    g.set_alive('h2', ('h2', 'p2'), now)
    g.set_alive('h3', ('h3', 'p1'), now)
    assert set(g.iter_alive_instances()) == {('h1', 'p1'), ('h1', 'p3'), ('h2', 'p2'), ('h3', 'p1')}

    g.set_dead('h1')
    assert set(g.iter_alive_instances()) == {('h2', 'p2'), ('h3', 'p1')}


def test_onlinestate():
    now = datetime.datetime.now()

    s = OnlineState()
    online_state._load_group = load_group

    s.update('group1', 'rev1', 'h1', 'p1', now)
    assert len(s.groups_on_host('h1')) == 1
    assert len(s.group_versions('group1')) == 1

    s.update('group1', 'rev2', 'h1', 'p1', now)
    assert len(s.groups_on_host('h1')) == 2
    assert len(s.group_versions('group1')) == 2

    s.update('group2', 'rev1', 'h1', 'p1', now)
    assert len(s.groups_on_host('h1')) == 3
    assert len(s.group_versions('group2')) == 1
    assert len(s.group_versions('group3')) == 0


def load_group(name, rev):
    group1 = {('h1', 'p1'), ('h1', 'p2'), ('h1', 'p3')}  # three instances on a single host
    group2 = {('h1', 'p1'), ('h2', 'p2')}  # intersects with the first group on one host
    group3 = {('h1', 'p1'), ('h1', 'p2'), ('h1', 'p3'), ('h2', 'p1'), ('h2', 'p2'), ('h3', 'p1')}

    return {
        ('group1', 'rev1'): group1,
        ('group1', 'rev2'): group1,  # the same
        ('group2', 'rev1'): group2,
        ('group3', 'rev1'): group3,
    }[(name, rev)]
