import textwrap


class HrSyntaxError(Exception):
    pass


class HrConfigurationChanged(Exception):
    def __init__(self, conf):
        super(HrConfigurationChanged, self).__init__(self, "%r configuration changed during hosts resolving" % conf)


class HrHostCheckFailedError(Exception):
    def __init__(self, errors):
        self.errors = errors
        Exception.__init__(self, "Check failed for some hosts")

    def format(self, width=80):
        grouped = {}
        for host, err in self.errors.items():
            grouped.setdefault(err, set()).add(host)

        for error, hosts in grouped.items():
            hostsstr = ', '.join(hosts)
            grouped[error] = '\n'.join(textwrap.wrap(
                hostsstr, width=width - 4,
                initial_indent=' ' * 4,
                subsequent_indent=' ' * 4,
                break_on_hyphens=False,
            ))

        return '\n'.join('- %s:\n%s' % (error, hosts) for error, hosts in grouped.items())
