import unittest

from expression import Literal, Clause, Dnf
from errors import HrSyntaxError


class TestExpressionFunctions(unittest.TestCase):
    def setUp(self):
        self.a = Literal('A')
        self.b = Literal('B')
        self.c = Literal('C')
        self.cl1 = Clause(set([self.a, self.b, Literal('AA', 'C')]))
        self.cl2 = Clause(set([self.a, self.c, Literal('TT', 'PP')]))

    def test_hash(self):
        self.assertEqual(hash(Literal('A')), hash(Literal('A')))

    def test_str(self):
        self.assertEqual(str(Clause(set([self.a, self.c, self.b]))), 'A & B & C')
        self.assertEqual(str(Dnf(set([self.cl1, self.cl2]))), 'A & B & C@AA | A & C & PP@TT')

    def test_add(self):
        self.assertEqual(
            str(Dnf(set([self.cl1])) + Dnf(set([self.cl2]))),
            'A & B & C@AA | A & C & PP@TT'
        )

    def test_sub(self):
        self.assertEqual(
            str(Dnf(set([self.cl1])) - Dnf(set([self.cl2]))),
            'A & B & C@AA & ~A | A & B & C@AA & ~C | A & B & C@AA & ~PP@TT'
        )

    def test_mul(self):
        a = self.a
        b = self.b
        self.assertEqual(str(Clause(set([b, a])) * Clause(set([a, b])) * Clause(set([b, a]))), 'A & B')
        self.assertEqual(
            str(~Dnf(set([self.cl1])) * ~Dnf(set([self.cl2]))),
            '~A | ~A & ~B | ~A & ~C | ~A & ~C@AA | ~A & ~PP@TT | ~B & ~C | ~B & ~PP@TT | ~C & ~C@AA | ~C@AA & ~PP@TT'
        )

    def test_prefix(self):
        a = Literal('A')
        a.set_prefix('B')
        self.assertEqual(str(a), 'B@A')

    def test_prefix_error(self):
        self.failUnlessRaises(HrSyntaxError, self.cl1.set_prefix, 'B')


if __name__ == '__main__':
    unittest.main()
