from unittest import TestCase

from hostsource import HostSource


class MockGroup(object):
    def __init__(self, prefix, name):
        self.prefix, self.name = prefix, name


class HostGroupsTest(TestCase):
    def test_groups_basic(self):
        hs = HostSource()
        gset = [
            MockGroup('H', '1'),
            MockGroup('K', '2'),
            MockGroup('d', '3'),
            MockGroup('l', '4'),
        ]

        def _chk(yr=None, conductor=None, dc=None, line=None):
            assert yr == set('1')
            assert conductor == set('2')
            assert dc == set('3')
            assert line == set('4')

        hs._resolve = _chk  # monkey patch
        hs.getHostsByGroups(gset)

    def test_groups_always_upper(self):
        hs = HostSource()
        gset = [
            MockGroup('H', 'x'),
            MockGroup('H', 'Y'),
            MockGroup('H', 'MiXeD'),
        ]

        def _chk(yr=None, conductor=None, dc=None, line=None):
            assert set(yr) == set([g.name.upper() for g in gset])

        hs._resolve = _chk  # monkey patch
        hs.getHostsByGroups(gset)
